/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.ShutdownChannelGroupException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.misc.Unsafe;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.ThreadPool;
import sun.security.action.GetPropertyAction;

class Iocp
extends AsynchronousChannelGroupImpl {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long INVALID_HANDLE_VALUE = -1L;
    private static final boolean supportsThreadAgnosticIo;
    private final ReadWriteLock keyToChannelLock = new ReentrantReadWriteLock();
    private final Map<Integer, OverlappedChannel> keyToChannel = new HashMap<Integer, OverlappedChannel>();
    private int nextCompletionKey = 1;
    private final long port;
    private boolean closed;
    private final Set<Long> staleIoSet = new HashSet<Long>();

    Iocp(AsynchronousChannelProvider asynchronousChannelProvider, ThreadPool threadPool) throws IOException {
        super(asynchronousChannelProvider, threadPool);
        this.port = Iocp.createIoCompletionPort(-1L, 0L, 0, this.fixedThreadCount());
    }

    Iocp start() {
        this.startThreads(new EventHandlerTask());
        return this;
    }

    static boolean supportsThreadAgnosticIo() {
        return supportsThreadAgnosticIo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void implClose() {
        Object object = this;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        Iocp.close0(this.port);
        object = this.staleIoSet;
        synchronized (object) {
            for (Long l : this.staleIoSet) {
                unsafe.freeMemory(l);
            }
            this.staleIoSet.clear();
        }
    }

    @Override
    boolean isEmpty() {
        this.keyToChannelLock.writeLock().lock();
        try {
            boolean bl = this.keyToChannel.isEmpty();
            return bl;
        }
        finally {
            this.keyToChannelLock.writeLock().unlock();
        }
    }

    @Override
    final Object attachForeignChannel(final Channel channel, FileDescriptor fileDescriptor) throws IOException {
        int n = this.associate(new OverlappedChannel(){

            @Override
            public <V, A> PendingFuture<V, A> getByOverlapped(long l) {
                return null;
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }
        }, 0L);
        return n;
    }

    @Override
    final void detachForeignChannel(Object object) {
        this.disassociate((Integer)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void closeAllChannels() {
        int n;
        OverlappedChannel[] overlappedChannelArray = new OverlappedChannel[32];
        do {
            this.keyToChannelLock.writeLock().lock();
            n = 0;
            try {
                for (Integer n2 : this.keyToChannel.keySet()) {
                    overlappedChannelArray[n++] = this.keyToChannel.get(n2);
                    if (n < 32) continue;
                    break;
                }
            }
            finally {
                this.keyToChannelLock.writeLock().unlock();
            }
            for (int i = 0; i < n; ++i) {
                try {
                    overlappedChannelArray[i].close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        } while (n > 0);
    }

    private void wakeup() {
        try {
            Iocp.postQueuedCompletionStatus(this.port, 0);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeOnHandlerTask(Runnable runnable) {
        Iocp iocp = this;
        synchronized (iocp) {
            if (this.closed) {
                throw new RejectedExecutionException();
            }
            this.offerTask(runnable);
            this.wakeup();
        }
    }

    @Override
    void shutdownHandlerTasks() {
        int n = this.threadCount();
        while (n-- > 0) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int associate(OverlappedChannel overlappedChannel, long l) throws IOException {
        int n;
        this.keyToChannelLock.writeLock().lock();
        try {
            if (this.isShutdown()) {
                throw new ShutdownChannelGroupException();
            }
            do {
                ++this.nextCompletionKey;
            } while (n == 0 || this.keyToChannel.containsKey(n));
            if (l != 0L) {
                Iocp.createIoCompletionPort(l, this.port, n, 0);
            }
            this.keyToChannel.put(n, overlappedChannel);
        }
        finally {
            this.keyToChannelLock.writeLock().unlock();
        }
        return n;
    }

    void disassociate(int n) {
        boolean bl = false;
        this.keyToChannelLock.writeLock().lock();
        try {
            this.keyToChannel.remove(n);
            if (this.keyToChannel.isEmpty()) {
                bl = true;
            }
        }
        finally {
            this.keyToChannelLock.writeLock().unlock();
        }
        if (bl && this.isShutdown()) {
            try {
                this.shutdownNow();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeStale(Long l) {
        Set<Long> set = this.staleIoSet;
        synchronized (set) {
            this.staleIoSet.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfStale(long l) {
        Set<Long> set = this.staleIoSet;
        synchronized (set) {
            boolean bl = this.staleIoSet.remove(l);
            if (bl) {
                unsafe.freeMemory(l);
            }
        }
    }

    private static IOException translateErrorToIOException(int n) {
        String string = Iocp.getErrorMessage(n);
        if (string == null) {
            string = "Unknown error: 0x0" + Integer.toHexString(n);
        }
        return new IOException(string);
    }

    private static native void initIDs();

    private static native long createIoCompletionPort(long var0, long var2, int var4, int var5) throws IOException;

    private static native void close0(long var0);

    private static native void getQueuedCompletionStatus(long var0, CompletionStatus var2) throws IOException;

    private static native void postQueuedCompletionStatus(long var0, int var2) throws IOException;

    private static native String getErrorMessage(int var0);

    static {
        IOUtil.load();
        Iocp.initIDs();
        String string = AccessController.doPrivileged(new GetPropertyAction("os.version"));
        String[] stringArray = string.split("\\.");
        supportsThreadAgnosticIo = Integer.parseInt(stringArray[0]) >= 6;
    }

    private static class CompletionStatus {
        private int error;
        private int bytesTransferred;
        private int completionKey;
        private long overlapped;

        private CompletionStatus() {
        }

        int error() {
            return this.error;
        }

        int bytesTransferred() {
            return this.bytesTransferred;
        }

        int completionKey() {
            return this.completionKey;
        }

        long overlapped() {
            return this.overlapped;
        }
    }

    private class EventHandlerTask
    implements Runnable {
        private EventHandlerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Invoker.GroupAndInvokeCount groupAndInvokeCount = Invoker.getGroupAndInvokeCount();
            boolean bl = groupAndInvokeCount != null;
            CompletionStatus completionStatus = new CompletionStatus();
            boolean bl2 = false;
            try {
                while (true) {
                    Object object;
                    if (groupAndInvokeCount != null) {
                        groupAndInvokeCount.resetInvokeCount();
                    }
                    bl2 = false;
                    try {
                        Iocp.getQueuedCompletionStatus(Iocp.this.port, completionStatus);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        int n = Iocp.this.threadExit(this, bl2);
                        if (n == 0 && Iocp.this.isShutdown()) {
                            Iocp.this.implClose();
                        }
                        return;
                    }
                    if (completionStatus.completionKey() == 0 && completionStatus.overlapped() == 0L) {
                        object = Iocp.this.pollTask();
                        if (object == null) {
                            return;
                        }
                        bl2 = true;
                        object.run();
                        continue;
                    }
                    object = null;
                    Iocp.this.keyToChannelLock.readLock().lock();
                    try {
                        object = (OverlappedChannel)Iocp.this.keyToChannel.get(completionStatus.completionKey());
                        if (object == null) {
                            Iocp.this.checkIfStale(completionStatus.overlapped());
                            continue;
                        }
                    }
                    finally {
                        Iocp.this.keyToChannelLock.readLock().unlock();
                        continue;
                    }
                    PendingFuture pendingFuture = object.getByOverlapped(completionStatus.overlapped());
                    if (pendingFuture == null) {
                        Iocp.this.checkIfStale(completionStatus.overlapped());
                        continue;
                    }
                    PendingFuture pendingFuture2 = pendingFuture;
                    synchronized (pendingFuture2) {
                        if (pendingFuture.isDone()) {
                            continue;
                        }
                    }
                    int n = completionStatus.error();
                    ResultHandler resultHandler = (ResultHandler)pendingFuture.getContext();
                    bl2 = true;
                    if (n == 0) {
                        resultHandler.completed(completionStatus.bytesTransferred(), bl);
                        continue;
                    }
                    resultHandler.failed(n, Iocp.translateErrorToIOException(n));
                }
            }
            finally {
                int n = Iocp.this.threadExit(this, bl2);
                if (n == 0 && Iocp.this.isShutdown()) {
                    Iocp.this.implClose();
                }
            }
        }
    }

    static interface OverlappedChannel
    extends Closeable {
        public <V, A> PendingFuture<V, A> getByOverlapped(long var1);
    }

    static interface ResultHandler {
        public void completed(int var1, boolean var2);

        public void failed(int var1, IOException var2);
    }
}

